#!/usr/bin/perl

#==========================================================
#   Nameless Chatroom
#
#   - A unicode Chatroom
#
#   Author          : Nekky Chan
#   Creation Time   : 11/11/2004
#   Version         : 1.0a
#
#
#
#
#   ***  Data Structure  ***
#
#   COOKIE Data (hash)... storing data from cookie
#   ------------------------------------------------
#   color : the color which user choose
#   doe   : time of expires.
#   flag  : indication of user attribute. (0 for normal, -1 for admin, 1 for blocked people)
#   id    : id to identify user.
#
#   FORM Data (hash) ... storing data from POST
#   -------------------------------------------------
#   ACTION          : what do user want to do.
#   ADMINPWD        : TRUE password for admin. to login.
#   COLOR           : user selected color.
#   CUSTOMCOLOR     : user defined color.
#   FLAG            : Miscellanous purpose.
#   PASSWORD        : actually meaningless .. it's for admin. to enter admin page.
#   SAVE            :
#   TALK1           : content one.
#   TALK2           : content two.
#   TARGET          : User target.
#
#   USERPREFER Data (hash) ... storing data from POST
#   -------------------------------------------------
#   COLOR       : user selected color.
#   NAME        : user name,.....
#   SEAT        : user data array index.
#
#   USERINFO file Data ...
#   --------------------------------------------------
#   1st line   : user name, sigh.
#
#   Chatroom Content file format
#   --------------------------------------------------
#   time, name, objname, message, color, bgcolor, ip
#


use POSIX qw(strftime setlocale LC_TIME);
use Fcntl;
use Encode;
use CGI::Carp;
#use strict 'refs';
no warnings;

open STDERR, ">>err.log";
$SIG{ALRM} = sub { die "it's already 5 seconds, timeout"; };
alarm(5);

$CURRTIME           = time();
$TIMEOFFSET         = 28800;  # time zone offset, GMT (in second)


# **** chatroom environment setting
# ****
$chatroom_title     = 'voNͲѫ';                # title of the chatroom
$chatroom_fname     = 'nameless.cgi';              # filename of the chatroom
$chatdata_fname     = 'nameless.txt';               # file that contain all content

# ---- since we use filename to store numeric data, so file prefix *MUST* contain *NO DIGIT* ----
$userinfo_fprefix   = 'nl_';                        # filename prefix, each user's info file.
$usertime_fprefix   = 'out_';                       # filename prefix, a file to know user should be here or out?

$updateinfo_fname   = 'up.flag';                    # filename, a file for anyone to update.
#$eventlog_fname     = 'evtlog.log';                 # filename of the event logger (only logged for login now)
#$adminlog_fname     = 'adminlog.log';               # filename of admin event (only logged for login now)

$max_user           = 24;                       # max. number of user in chatroom (upper limit is 99, not recommended)
$max_line           = 30;                       # max. lines in whole chatroom
$line_maxlength     = 180;                      # max. length of each line

$user_idle          = 600;                 # in seconds  (default 3mins)
$user_lost          = 1800;                # in seconds  (default 10mins)
$refresh_norm       = 15;                  # in seconds  (default 15 sec)
$refresh_idle       = $user_lost / 12;     # in seconds


# ****  environment setting
# ****
$welcome_text       = 'Welcome to mystery. ~';
$admin_welcometext  = ', wAiJ޲z̰ϰ, пJ޲ẕKX.';
$chatview_text      = 'eCreloads@A(now ɶ) <span style=\'font-size:10px\'>[lost]</span>';
$login_text         = 'iJѫǡAæVjaݦn^^C';
$autologout_text    = 'ŤC';
$logout_text        = 'wg}ѫǡC';
$exit_text          = 'Bye Bye, See you next time.';

$fontsize1          = '13px';
$textcolor1         = '#996699';
$textcolor2         = 'red';
$textcolorA         = '#7f7fff';                   # text color for important part
$bgcolor1           = '#f7fff7';                   # background color for general part
$bgcolor2           = 'white';                     # background color for general content
$bgcolorA           = '#FFFF99';                   # background color for important part


# ****  color setting
# ****
@text_color = (  '¦' => '#000000',      # color selection for chat content
                 '' => '#ffd033',
                 '' => '#cc0033',
                 '' => '#ff6600',
                 '' => '#cc9933',
                 '¦' => '#995599',
                 '' => '#ff00cc',
                 '' => '#ff3399',
                 'L' => '#0099cc',
                 '`' => '#0033cc',
                 'L' => '#669900',
                 '`' => '#006633',
                 'L' => '#FF00FF',
                 'L' => '#CC33FF',
                 '' => '#9933FF',
                 '`' => '#800080',
);


# ****  user setting
# ****
$DEFAULT_NAME       = decode("big5", 'LW'); # Default name for user if they use unsuitable name
$name_maxlength     = 24;                       # max. length of user name

$USERPREFER{'COLOR'} = '#000000';               # Default color setting


# ****  adminstration setting
# ****
$ADMINPASS          = '12345';             # ADMINISTRATOR PASSWORD
$ENTERPASS          = undef;               # If chatroom is *PRIVATE* one, define it with a value.


#--------------------  Program Begin  ---------------------------
get_form();
get_cookie();

$USERMON = tie @USERNAME, "TieUserMonitor", $max_user, $userinfo_fprefix, $usertime_fprefix;
get_authentication();

if ($FORM{'FLAG'} eq 'logout' and defined($USERPREFER{'SEAT'})) {
    chat_logout();
    alarm(0);
    exit;
}

if ($ENV{'QUERY_STRING'} =~ /view$/) {
    if ( defined($USERPREFER{'NAME'}) and defined $FORM{'TALK2'} ) {
        talkit();
    }
    elsif (defined($USERPREFER{'NAME'}) and $ENV{'QUERY_STRING'} ne 'userview') {
        auto_logout();
        show_contentview();
    }
    else {
        auto_logout();
        show_userview();
    }
    alarm(0);
    exit;
}

if ($ENV{'QUERY_STRING'} eq 'input') {
    if (defined($USERPREFER{'NAME'})) {
        show_inputpanel();
    }
    elsif (exists($FORM{'PASSWORD'})) {
        chat_login();
        show_inputpanel(1);
    }
    elsif (exists($FORM{'ADMINPWD'})) {
        admin_login();
        show_inputpanel(1);
    }
    else {
        show_entrance();
    }
    alarm(0);
    exit;
}

print_indexpage();
alarm(0);
exit;


#========================================================================
#
#   ~ CHATROOM  **ACTION** ~
#
#       render various chatroom activities to proper output.
#
#
BEGIN {
@twoinputaction = (2, 3);

$ACTIONLIST[0] = '͸';
$ACTIONFILTERSET[0] = sub {
    return (($FORM{'TARGET'} != $USERPREFER{'SEAT'}) ?
                  decode("big5", "  <span style=\"color:$textcolorA\">||target||</span> G ") :
                  decode("big5", " ۨۻyaG "))
           . $FORM{'TALK2'};
};

$ACTIONLIST[1] = 'ܰκ';
$ACTIONFILTERSET[1] = sub {
    $USERPREFER{'COLOR'} = $textcolorA;
    $USERPREFER{'NAME'}  = $FORM{'TALK2'} || $DEFAULT_NAME;
    $USERPREFER{'NAME'}  =~ s/</&lt;/g;
    substrwidth(\$USERPREFER{'NAME'}, $name_maxlength);

    $USERNAME[$USERPREFER{'SEAT'}] = $USERPREFER{'NAME'};

    return  "\x{21D2}" . decode("big5", 'Wr') . "\x{21D2} $USERPREFER{'NAME'}";
};

$ACTIONLIST[2] = 's';
$ACTIONFILTERSET[2] = sub {
    ($FORM{'TALK2'} !~ m!^http://!) and ($FORM{'TALK2'} = 'http://' . $FORM{'TALK2'});
    $FORM{'TALK2'} =~ s/'/\%27/g;
    return  decode('big5', ' ||target|| G') .
            "<a  href='$FORM{TALK2}'  target='_blank'>CLICK HERE</a> - $FORM{'TALK1'}";
};

$ACTIONLIST[3] = 'Yl';
$ACTIONFILTERSET[3] = sub {
    if (($roll, $dice, $modifier) = $FORM{'TALK2'} =~ /^(\d+)d(\d+)([+-]\d+)?$/i) {
        if (($roll < 1) || ($roll > 10)) { $roll = 1; }
        if (($dice < 4) || ($dice > 100)) { $dice = 6; }
        if (!defined($modifier) or abs($modifier > 20)) { $modifier = 0; }
    } else {
        $roll = 1;
        $dice = 6;
        $modifier = 0;
    }

    $diceresult = 0;
    for ($i = 0; $i < $roll; $i++) {
        my $result = (int(rand $dice) + 1);
        $diceresult += $result;
        $output .= " + $result";
    }

    $output =~ s/^ \+ //;
    $output .= ' = ' . ($diceresult + $modifier);

    return ($FORM{'TALK1'}) ?
                "$FORM{'TALK1'}<br/>&nbsp;&nbsp;$roll D $dice + ($modifier) \x{21D2} $output" :
                "&nbsp;&nbsp;$roll D $dice + ($modifier) \x{21D2} $output";
};

$ACTIONLIST[4] = 'free form(Ȯ)';
$ACTIONFILTERSET[4] = sub {
    return "$FORM{'TALK2'}";
};

$ACTIONLIST[5] = 'Me';
$ACTIONFILTERSET[5] = sub {
    if ($COOKIE{flag} == -1   or  $FORM{'TALK2'} eq 'cleanit') {
        $filemode = '>';
        $USERPREFER{'COLOR'} = $textcolorA;
        $USERPREFER{'BGCOLOR'} = $bgcolorA;

        $name = decode("big5", "t");
        $msg = decode("big5", "Ӥ[SFAuserlkNѫǤ@ӪšI");
        $msg =~ s/user/$USERPREFER{NAME}/g;
        return $msg;
    }
    else {
        return decode("big5", "XMѫǪnСC");
    }
};

}

#========================================================================
#========================================================================

#------------------------------------------------------------
#   subroutine chat_login
sub chat_login {
    if ($FORM{'PASSWORD'} eq 'admin') {
        show_admin_entrance();
        alarm(0);
        exit;
    }

    if ( defined $ENTERPASS and $FORM{'PASSWORD'} ne $ENTERPASS) {
        show_error("This is a private chatroom, you need a password to enter.");
        alarm(0);
        exit;
    }

    $USERPREFER{'NAME'}  = $FORM{'NAME'} || $DEFAULT_NAME;
    $USERPREFER{'NAME'}  =~ s/</&lt;/g;
    substrwidth(\$USERPREFER{'NAME'}, $name_maxlength);

    $COOKIE{'color'}    = $USERPREFER{'COLOR'} =
            ($FORM{'CUSTOMCOLOR'} =~ /^[0-9A-Fa-f]{6}$/) ? "#$FORM{'CUSTOMCOLOR'}" : $FORM{'COLOR'};
    $COOKIE{'doe'}      = $CURRTIME + $user_lost;
    $COOKIE{'dou'}      = $CURRTIME;
    $COOKIE{'flag'}     = 0;
    $COOKIE{'id'}       = $CURRTIME % 100000;

    show_error("Chatroom is already full")
    unless defined( $USERPREFER{'SEAT'} = $USERMON->create($COOKIE{'id'}, $USERPREFER{'NAME'}) );

    unless (open FH, ">:utf8", "${usertime_fprefix}$COOKIE{'doe'}.$USERPREFER{'SEAT'}") {
        delete $USERNAME[$USERPREFER{'SEAT'}];
        croak("Can't create outdate check file.");
    }
    close(FH);

    set_cookie();

    setlocale(LC_TIME,"C");
    my $now    = strftime( "&#x3010;%H:%M:%S&#x3011;", gmtime($CURRTIME + $TIMEOFFSET) );
    my $text   = decode("big5", $login_text);

    tie *FH, Buffered_ContinuousFile, $chatdata_fname, $max_line;
    open FH, '>>';
    binmode(FH, ':utf8');
    print FH join("\t", $now, $USERPREFER{NAME}, '', $text, $textcolorA, $bgcolorA, $ENV{REMOTE_ADDR});
    print FH "\n";
    close FH;

    set_updateflag();
}


#------------------------------------------------------------
#   subroutine admin_login
sub admin_login {
    unless ($FORM{'ADMINPWD'} eq $ADMINPASS) {
        show_error("RESTRICTED AREA - ACCESS IS NOT ALLOWED");
        alarm(0);
        exit;
    }

    $USERPREFER{'NAME'}  = $FORM{'NAME'} || $DEFAULT_NAME;
    $USERPREFER{'NAME'}  =~ s/</&lt;/g;
    substrwidth(\$USERPREFER{'NAME'}, $name_maxlength);

    $COOKIE{'color'}    = $USERPREFER{'COLOR'}      = $FORM{'COLOR'};
    $COOKIE{'doe'}      = $CURRTIME + $user_lost;
    $COOKIE{'dou'}      = $CURRTIME;
    $COOKIE{'flag'}     = -1;
    $COOKIE{'id'}       = $CURRTIME % 100000;

    show_error("Chatroom is already full")
    unless defined( $USERPREFER{'SEAT'} = $USERMON->create($COOKIE{'id'}, $USERPREFER{'NAME'}) );

    unless (open FH, ">:utf8", "${usertime_fprefix}$COOKIE{'doe'}.$USERPREFER{'SEAT'}") {
        delete $USERNAME[$USERPREFER{'SEAT'}];
        croak("Can't create outdate check file.");
    }
    close(FH);

    set_cookie();

    setlocale(LC_TIME,"C");
    my $now    = strftime( "&#x3010;%H:%M:%S&#x3011;", gmtime($CURRTIME + $TIMEOFFSET) );
    my $text   = decode("big5", $login_text);

    tie *FH, Buffered_ContinuousFile, $chatdata_fname, $max_line;
    open FH, '>>';
    binmode(FH, ':utf8');
    print FH join("\t", $now, "<u>$USERPREFER{NAME}</u>", '', $text, $textcolorA, $bgcolorA, $ENV{REMOTE_ADDR});
    print FH "\n";
    close FH;

    set_updateflag();
}


#------------------------------------------------------------
#   subroutine chat_logout
sub chat_logout {
    setlocale(LC_TIME,"C");
    my $now    = strftime( "&#x3010;%H:%M:%S&#x3011;", gmtime($CURRTIME + $TIMEOFFSET) );
    my $text   = decode("big5", $logout_text);
    my $name   = ($COOKIE{flag} == -1) ? "<u>$USERPREFER{NAME}</u>" : $USERPREFER{NAME};

    delete $USERNAME[$USERPREFER{'SEAT'}];

    $COOKIE{'doe'}      = 10000;
    $COOKIE{'flag'}     = 0;
    $COOKIE{'id'}       = 0;
    set_cookie();

    tie *FH, Buffered_ContinuousFile, $chatdata_fname, $max_line;
    open FH, '>>';
    binmode(FH, ':utf8');
    print FH join("\t", $now, $name, '', $text, $textcolorA, $bgcolorA, $ENV{REMOTE_ADDR});
    print FH "\n";
    close FH;

    print_htmlheader();
    print <<"END__DOC";
<meta http-equiv="refresh" content="3; ${chatroom_fname}">
</head>
<body><center>$exit_text</center></body></html>
END__DOC
}


#------------------------------------------------------------
#   subroutine auto_logout
sub auto_logout {
    $checkresult = $USERMON->timecheck($CURRTIME);

    setlocale(LC_TIME,"C");
    my $now    = strftime( "&#x3010;%H:%M:%S&#x3011;", gmtime($CURRTIME + $TIMEOFFSET) );
    my $text   = decode("big5", $autologout_text);

    tie *FH, Buffered_ContinuousFile, $chatdata_fname, $max_line;
    open FH, '>>';
    binmode(FH, ':utf8');
    for (my $i = 0; $i < $max_user; $i++) {
        $$checkresult[$i] or next;
        my $name = $USERNAME[$i];
        delete $USERNAME[$i];
        print FH join("\t", $now, $name, '', $text, $textcolorA, $bgcolorA, '127.0.0.1');
        print FH "\n";
    }
    close FH;
}


#------------------------------------------------------------
#   subroutine talkit
sub talkit {
    setlocale(LC_TIME,"C");
    local $now         = strftime( "&#x3010;%H:%M:%S&#x3011;", gmtime($CURRTIME + $TIMEOFFSET) );
    local $name        = ($COOKIE{flag} == -1) ? "<u>$USERPREFER{NAME}</u>" : $USERPREFER{NAME};
    local $objname     = ($FORM{'TARGET'} == -1) ? decode("big5", "ja") : $USERNAME[$FORM{'TARGET'}];

    $COOKIE{'color'} = $USERPREFER{'COLOR'} =
            ($FORM{'CUSTOMCOLOR'} =~ /^[0-9A-Fa-f]{6}$/) ? "#$FORM{'CUSTOMCOLOR'}" : $FORM{'COLOR'};
    $COOKIE{'doe'} = $CURRTIME + $user_lost;
    set_cookie();

    substrwidth(\$FORM{'TALK2'}, $line_maxlength);
    substrwidth(\$FORM{'TALK2'}, $line_maxlength);
    $USERPREFER{'BGCOLOR'} = $bgcolor2;

    local $text = $ACTIONFILTERSET[$FORM{'ACTION'}]->();
    defined($filemode) or $filemode = '>>';

    tie *FH, Buffered_ContinuousFile, $chatdata_fname, $max_line;
    open FH, $filemode;
    binmode(FH, ':utf8');
    print FH join("\t", $now, $name, $objname, $text, $USERPREFER{'COLOR'}, $USERPREFER{'BGCOLOR'}, $ENV{REMOTE_ADDR});
    print FH "\n";
    close FH;

    unlink(glob "${usertime_fprefix}*.$USERPREFER{'SEAT'}");
    open TMP, '>', "${usertime_fprefix}$COOKIE{'doe'}.$USERPREFER{'SEAT'}";
    close TMP;

#    show_contentview();
    print "Location: http://$ENV{'HTTP_HOST'}$ENV{'REQUEST_URI'}?view\n\n";
}



#------------------------------------------------------------
#   subroutine substrwidth
sub substrwidth {
    my $string = shift;      # a reference of scalar that being modified.
    my $limit = shift;       # max width for the string (where full width = 2 half width char.)

    (ref($string) eq "SCALAR") or croak ("first argument require a reference of scalar");
    (2 * length($$string) > $limit) or return;

    unless ($$string =~ /\P{ASCII}/) {
        (length($$string) > $limit) or return;
        substr($$string, $limit) = "";
        return;
    }

    #-------  Unicode 4.0.0 Full-width and wide character  --------
    $re = qr/[\x{1100}-\x{115F}\x{2329}\x{232A}\x{2E80}-\x{2FFB}\x{3001}-\x{4DB5}\x{4E00}-\x{9FA5}
            \x{A000}-\x{A4C6}\x{AC00}-\x{D7A3}\x{F900}-\x{FA6A}\x{FE30}-\x{FE6B}\x{FF01}-\x{FF60}
            \x{FFE0}-\x{FFE6}\x{20000}-\x{2A6D6}\x{2F800}-\x{2FA1D}]/;
    #---------------------------------------------------------------

    while ( ($$string =~ /$re/g) && (pos($$string) < $limit--) ) {  }
    (length($$string) > $limit) or return;
    substr($$string, $limit) = "";
}


#------------------------------------------------------------
#   subroutine get_authentication
sub get_authentication {
    $USERPREFER{'COLOR'} = $COOKIE{'color'} || $USERPREFER{'COLOR'};

    ($COOKIE{'flag'} == 1) and show_error("You are temporatory unwelcome to chatroom!!");
#    ($COOKIE{'doe'} < $CURRTIME + 5) and return;

    defined( $USERPREFER{'SEAT'} = $USERMON->whereami($COOKIE{'id'}) ) or return;
    $USERPREFER{'NAME'} = $USERNAME[$USERPREFER{'SEAT'}];
}


#------------------------------------------------------------
#   subroutine get_form
sub get_form {
    read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});
    @data = split(/&/, $buffer);
    foreach (@data) {
        my ($name, $value) = split /=/;
        $value =~ tr/+/ /;
        $value =~ s/%([0-9a-fA-F][0-9a-fA-F])/pack("C", hex($1))/ge;
        $value =~ s# < (?! /? [buis] >) #&lt;#xig;
        $value =~ tr/\x00-\x19//d;
        $FORM{$name} = ($value) ? decode_utf8($value) : '';
    }
}


#------------------------------------------------------------
#   subroutine get_cookie
sub get_cookie {
    my @ALLCOOK = split(/;/, $ENV{'HTTP_COOKIE'});
    foreach (@ALLCOOK) {
        my ($name,$value) = split(/=/, $_);
        $name =~ s/\s+//g;
        ($name eq 'Nameless1') or next;
        $cookie = $value;
        last;
    }

    ($COOKIE{'color'}, $COOKIE{'doe'}, $COOKIE{'dou'}, $COOKIE{'flag'}, $COOKIE{'id'}) = split(/\:/, $cookie, 5);
    ($COOKIE{'color'}   =~ /^#[0-9A-Fa-f]{6}$/) or ($COOKIE{'color'}    = '#000000');
    ($COOKIE{'doe'}     =~ /^[0-9]+$/)          or ($COOKIE{'doe'}      = "10000");
    ($COOKIE{'dou'}     =~ /^[0-9]+$/)          or ($COOKIE{'dou'}      = "10000");
    ($COOKIE{'flag'}    =~ /^-?[0-9]+$/)        or ($COOKIE{'flag'}     = "0");
    ($COOKIE{'id'}      =~ /^[0-9]+$/)          or ($COOKIE{'id'}       = "0");
}


#------------------------------------------------------------
#   subroutine check_updateflag
sub check_updateflag {
    ((stat $updateinfo_fname)[9] - $COOKIE{dou} > 3) and print <<END__DOC;
<script>
    if ((window.parent != window) && (window.parent.frames[1].name == 'chatinput')) {
       window.parent.document.getElementById("chatinput").setAttribute("refreshflag", "1");
    }
</script>
END__DOC
}


#------------------------------------------------------------
#   subroutine set_updateflag
sub set_updateflag {
    open(TMP, ">", $updateinfo_fname);
    close TMP;
}


#------------------------------------------------------------
#   subroutine set_cookie
sub set_cookie {
    ($COOKIE{'color'}   =~ /^#[0-9A-Fa-f]{6}$/) or ($COOKIE{'color'}    = '#000000');
    ($COOKIE{'doe'}     =~ /^[0-9]+$/)          or ($COOKIE{'doe'}      = "10000");
    ($COOKIE{'dou'}     =~ /^[0-9]+$/)          or ($COOKIE{'dou'}      = "10000");
    ($COOKIE{'flag'}    =~ /^-?[0-9]+$/)        or ($COOKIE{'flag'}     = "0");
    ($COOKIE{'id'}      =~ /^[0-9]+$/)          or ($COOKIE{'id'}       = "0");
    $cook = join(":", $COOKIE{'color'}, $COOKIE{'doe'}, $COOKIE{'dou'}, $COOKIE{'flag'}, $COOKIE{'id'});

    setlocale(LC_TIME,"C");
    $expire = strftime("%A, %d-%b-%Y %H:%M:%S GMT", gmtime($CURRTIME + 60*24*60*60));

    print "Set-Cookie: Nameless1=$cook; expires=$expire\n";
}


#------------------------------------------------------------
#   subroutine print_allactionoption
sub print_allactionoption {
    my $actionlist = join(':', @ACTIONLIST);
    @ACTIONLIST = split/:/, decode("big5", $actionlist);
    for ($i = 0; $i <= $#ACTIONLIST; $i++) {
        print "<option  value=\"$i\"> $ACTIONLIST[$i] </option>";
    }
}


#------------------------------------------------------------
#   subroutine print_allcoloroption
sub print_allcoloroption {
    my $colorlist = join(':', @text_color);
    @text_color1 = split/:/, decode("big5", $colorlist);
    $colorlist = '';
    while (my $text = shift @text_color1) {
        my $colorcode = shift @text_color1;
        $colorlist = ($colorcode =~ m/$USERPREFER{'COLOR'}/i ) ?
                join('', $colorlist, "<option  value=\"$colorcode\"  selected=\"selected\  style=\"color:white;background:$colorcode;\"> $text </option>") :
                join('', $colorlist, "<option  value=\"$colorcode\" style=\"color:white;background:$colorcode;\"> $text </option>");
    }
    print $colorlist;
}


#------------------------------------------------------------
#   subroutine print_alluseroption
sub print_alluseroption {
    print decode("big5", '<option  value=\'-1\'>ja</option>');
    for (my $i = 0, $j = 1; $i < $max_user; $i = $j++) {
        defined($USERNAME[$i]) or next;
        print "<option  value='$i'>($j) $USERNAME[$i]</option>";
    }
}


#------------------------------------------------------------
#   subroutine print_htmlheader
sub print_htmlheader {
    setlocale(LC_TIME,"C");
    print 'Expires: ', strftime("%a, %d %b %Y %H:%M:%S GMT", gmtime()), "\n";
    print "Content-Type: text/html; charset=UTF-8\n\n";
    print <<END__HERE;
<html>
<head>
<title>$chatroom_title</title>
<noscript>
this chatroom require javascript, please enable javascript function or use another broswer.
</noscript>
END__HERE
}


#------------------------------------------------------------
#   subroutine print_indexpage
sub print_indexpage {
    print "Content-Type: text/html; charset=UTF-8\n\n";
    print <<END__HERE;
<html>
<head>
<title>$chatroom_title</title>
<noscript>
this chatroom require javascript, please enable javascript function or use another broswer.
</noscript>
<script>
    if ((window.name == "chatview") || (window.name == "chatinput")) {
        window.parent.Location = "$chatroom_fname";
    }
</script>
</head>
<frameset  rows="*,100px">
<frame  id="chatview"  name="chatview"  frameborder="0"  src="${chatroom_fname}?view">
<frame  id="chatinput"  name="chatinput"  frameborder="0"  scrolling="no"  src="${chatroom_fname}?input">
</frameset>
</html>
END__HERE
}


#------------------------------------------------------------
#   subroutine show_error
sub show_error {
    print "Content-Type: text/html; charset=UTF-8\n\n";
    print <<END__HERE;
<!DOCTYPE html
     PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
     "DTD/xhtml1-transitional.dtd">
<html  xmlns="http://www.w3.org/1999/xhtml"  xml:lang="en"  lang="en">
<head>
<title>$chatroom_title</title>
</head>
<body>
$_[0];
</body>
</html>
END__HERE
    alarm(0);
    exit;
}


#------------------------------------------------------------
#   subroutine show_userview
sub show_userview {
    print_htmlheader();
    print decode("big5", <<"END__HERE");
<style  type="text/css">
body   { background : $bgcolor1 }
table  { text-align : center;
         background : white;
         color      : #006633;
         font-size  : $fontsize1; }
</style>
</head>
<body>
<center>
<table  cellpadding="0"  cellspacing="0"  border="1"  style="width : 90%">
<col  width="50px" /><col  width="*" /><col  width="170px" />
<tr><td>WH</td><td>κ</td><td>̫oɶ(/ :)</td></tr>
END__HERE

    setlocale(LC_TIME,"C");
    $usertime = $USERMON->timelist();
    for (my $i = 0, $j = 1; $i < $max_user; $i = $j++) {
        print "<tr><td>$j</td><td>",
              exists($USERNAME[$i]) ? $USERNAME[$i] : 'N/A',
              '</td><td>',
              (exists($usertime->[$i]) && exists($USERNAME[$i])) ?
                    strftime("%d/%m  %H:%M ", gmtime($usertime->[$i] - $user_lost + $TIMEOFFSET)) :
                    'N/A',
              "</td></tr>\n";
    }

    print <<'END__HERE';
</table></center>
</body></html>
END__HERE
}


#------------------------------------------------------------
#   subroutine show_entrance
sub show_entrance {
    print_htmlheader();
    (my $color = $COOKIE{color}) =~ s/^#//;
    print decode("big5", <<"END__HERE");
<style  type="text/css">
body  { background : $bgcolor1;
        font-size  : $fontsize1; }
</style>
<script>
submited = 0;
function submitcheck() {
    document.getElementById("submitbtn").disabled == true;
    if (submited == 1) { return false; }
    submited = 1;
    return true;
}
</script>
</head>
<body>
$welcome_text
<form  id="enterform"  method="POST"  target="chatinput"  action="${chatroom_fname}?input"
       onsubmit="return submitcheck()">
κ <input  name="NAME"  type="text"  size="$name_maxlength" />&nbsp;
C <select  name="COLOR"  size="1">
END__HERE

    print_allcoloroption();
    print decode("big5", <<"END__HERE");
</select>
 / <input  name="CUSTOMCOLOR"  type="text"  maxlength="6"  size="6"  value="$color" />&nbsp;
tX <input  name="PASSWORD"  type="password"  size="6" />&nbsp;
<input  id="submitbtn"  type="submit"  value="iJ" />
</form>
</body>
</html>
END__HERE
}


#------------------------------------------------------------
#   subroutine show_admin_entrance
sub show_admin_entrance {
    $USERPREFER{'COLOR'} =
        ($FORM{'CUSTOMCOLOR'} =~ /^[0-9A-Fa-f]{6}$/) ? "#$FORM{'CUSTOMCOLOR'}" : $FORM{'COLOR'};
    print_htmlheader();
    print decode("big5", <<"END__HERE");
<style  type="text/css">
body  { background : $bgcolor1; }
</style>
</head>
<body>
END__HERE

    print $FORM{'NAME'};
    print decode("big5", <<"END__HERE");
$admin_welcometext
<form  id="enterform"  method="POST"  target="chatinput"  action="${chatroom_fname}?input">
END__HERE

    print "<input  name=\"NAME\"  type=\"hidden\"  value=\"$FORM{'NAME'}\" />";
    print "<input  name=\"COLOR\"  type=\"hidden\"  value=\"$USERPREFER{'COLOR'}\" />";
    print decode("big5", <<"END__HERE");
޲ẕKX <input  name="ADMINPWD"  type="password"  size="6" />&nbsp;
<input  type="submit"  value="`nJ" />&nbsp;
<input  type="button"  value="nJ" />
</form>
</body>
</html>
END__HERE
}


#------------------------------------------------------------
#   subroutine show_inputpanel
sub show_inputpanel {
    $COOKIE{'dou'}      = $CURRTIME;
    set_cookie();

    $javascriptRE = join('|', @twoinputaction);

    print_htmlheader();
    print <<"END__HERE";
<style>
body               { font-size      : $fontsize1;
                     vertical-align : middle; }
input              { border         : solid 1px green;
                     background     : $bgcolor1; }
select             { background     : $bgcolor1;
                     color          : black; }
form               { display        : inline; }
</style>

<script>
checking = 0;
function byebye() {
    if (!confirm("Confirm to leave?")) { return; }
    document.getElementById('form2').target = '_parent';
    document.getElementById('FLAG').value = 'logout';
    document.getElementById('form2').action = '$chatroom_fname';
    document.getElementById('form2').submit();
}
function wholerefresh() {
    document.getElementById('form2').target = '_parent';
    document.getElementById('form2').action = '$chatroom_fname';
    document.getElementById('form2').submit();
}
function showuserview() {
    document.getElementById('form2').target = '_blank';
    document.getElementById('form2').action = '$chatroom_fname?userview';
    document.getElementById('form2').submit();
}
function refreshpanel() {
    document.getElementById('form2').target = 'chatinput';
    document.getElementById('form2').action = '$chatroom_fname?input';
    document.getElementById('form2').submit();
}
function submitcheck() {
    if (document.getElementById('TALK2').value != '') {
        dummy = setTimeout('document.getElementById("form1").reset();' +
                           'document.getElementById("COLOR").value = dummy2;' +
                           'refreshcheck();', 100);
        dummy2 = document.getElementById('COLOR').value;
        document.getElementById('CUSTOMCOLOR').defaultValue = document.getElementById('CUSTOMCOLOR').value;
        document.getElementById('TALK2').focus();
        return true;
    }
    alert("empty message");
    refreshcheck();
    return false;
}
function refreshcheck() {
    if (checking == 1) { return; }
    checking = 1;
    if ( window.parent.document.getElementById("chatinput").getAttribute("refreshflag") == 1 ) {
        window.parent.document.getElementById("chatinput").setAttribute("refreshflag", "1");
        refreshpanel();
    }
    checking = 0;
}
function resetcolor() {
    document.getElementById('CUSTOMCOLOR').defaultValue = '';
    document.getElementById('CUSTOMCOLOR').value = '';
}
function actionchange() {
    if ( document.getElementById('ACTION').value.search(/^($javascriptRE)\$/) != -1 ) {
        document.getElementById('TALK1').readOnly = false;
    }
    else {
        document.getElementById('TALK1').readOnly = true;
        document.getElementById('TALK1').value = '';
    }
}
</script>
</head>
END__HERE

    print decode("big5", <<"END__HERE");
<body>
<form  id="form1"  method="POST"  target="chatview"  action="$chatroom_fname?view"  onsubmit="return submitcheck()">
ʧ@ <select  id="ACTION"  name="ACTION"  size="1" style="width:100px"  onchange="actionchange()">
END__HERE

# !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
#        HTML output for Any "ACTION" option.

    print_allactionoption();

# !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

    print decode("big5", <<"END__HERE");
</select>
H <select  id="TARGET"  name="TARGET"  size="1"  style="width:150px">
END__HERE

# !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
#        HTML output for Any "TARGET" option.

    print_alluseroption();

# !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

    print decode("big5", <<"END__HERE");
</select>
C <select  id="COLOR"  name="COLOR"  size="1"  onchange="resetcolor()">
END__HERE

# !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
#        HTML output for Any "COLOR" option.

    print_allcoloroption();
    $USERPREFER{COLOR} =~ tr/#//d;

# !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

    print decode("big5", <<"END__HERE");
</select>/<input  id="CUSTOMCOLOR"  name="CUSTOMCOLOR"  type="text"  size="6"  maxlength="6"  value="$USERPREFER{COLOR}" />
xs <input  id="SAVE"  name="SAVE"  type="checkbox" /><br />
 <input  id="TALK1"  name="TALK1"  type="text"  size="15"  readonly="readonly" />
<input  id="TALK2"  name="TALK2"  type="text"  size="54"  tabindex="1" /><br />
<input  type="submit" />
</form>
<form  id="form2"  method="POST"  target="_blank"  action="$chatroom_fname">
<input  id="FLAG"  name="FLAG"  type="hidden"  value="" />
<input  id="refresh"  type="button"  value="s"  onclick="wholerefresh()" />
<input  id="userview"  type="button"  value="HW"  onclick="showuserview()" />
<input  id="tmpview"  type="button"  value="\ŪO"   style="visibility:hidden" />
<input  id="goldview"  type="button"  value="\ŪѫǬ"   style="visibility:hidden" />
<input  id="leave"  type="button"  value="}"  onclick="byebye()" />
</form>
END__HERE

# !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
#        script for display USERVIEW.

    ($_[0]) and print <<"END__HERE";
<script>
    document.getElementById('form2').target = 'chatview';
    document.getElementById('form2').action = '$chatroom_fname?view';
    document.getElementById('form2').submit();
</script>
END__HERE

# !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

    print <<'END__HERE';
<script>
document.getElementById('TALK2').focus();
</script>
</body>
</html>
END__HERE
}


#------------------------------------------------------------
#   subroutine show_contentview
sub show_contentview {
    setlocale(LC_TIME,"C");
    my $now    = strftime( "%d-%b-%Y %H:%M:%S ", gmtime($CURRTIME + $TIMEOFFSET) );
    my $lost   = strftime( "%H:%M:%S", gmtime($COOKIE{doe} + $TIMEOFFSET) );
    my $reload = $refresh_norm;

    my $header = decode("big5", $chatview_text);
    $header =~ s/now/$now/g;
    $header =~ s/reload/$reload/g;
    $header =~ s/lost/$lost/g;

    print_htmlheader();
    print <<END__DOC;
<meta http-equiv="refresh" content="$reload; ${chatroom_fname}?view">
<style>
*     { font-size      : 13px;
        line-height    : 1.2em; }
body  { margin-top     : 4px; }
table { margin         : 4px;
        width          : 95%; }
div   { text-align     : center;
        background     : $bgcolorA;
        color          : $textcolorA; }
td.d1 { text-align     : center;
        vertical-align : top; }
</style>
</head><body>
<div>$header</div>
<center>
<table  cellspacing="0px"  cellpadding="1px"  border="0">
<col  width="60px" />
<col  width="120px" />
<col  width="*" />
END__DOC

# !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
#        HTML output for Chatting content.
    tie *FH, Buffered_ContinuousFile, $chatdata_fname, $max_line;
    open FH;
    my @lines = <FH>;
    close FH;

    foreach (reverse @lines) {
        my ($time, $name, $name2, $context, $color, $bgcolor, $ip) = split /\t/;
        $context =~ s#\|\|target\|\|#$name2#g;
        print "<tr  style='background:$bgcolor'>",
              "<td  style='color:$textcolor1'>$time</td>",
              "<td  class='d1'  style='color:$textcolor2'>$name</td>",
              "<td  style='color:$color'>$context</td></tr>\n";
    }

# !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

    print "</table></center>";
    check_updateflag();
    print "</body></html>";
}




#-------------------------------------------------------------------------------------------------
#
#       PACKAGE      TieUserMonitor
#

package TieUserMonitor;
use Fcntl;
use CGI::Carp;

sub TIEARRAY {
    my $class           = shift;
    my $bound           = shift;
    my $userinfoprefix  = shift;
    my $usertimeprefix  = shift;

    confess "useage: tie(\@array, 'TieUserMonitor', max_user, userinfo_filename, usertime_filename)"
        if ($bound =~ /[^0-9]/ or !defined($userinfoprefix) or !defined($usertimeprefix));

    my $namelist        = ();
    $#{$namelist}       = $bound - 1;

    $user_filenames = join( "", $userinfoprefix, '*.*');
    foreach $filename (glob($user_filenames)) {
        (undef, $index) = split /\./, $filename;
        $index =~ /^[0-9]+$/ or next;
        $namelist->[$index] = undef;
    }

    my $obj = { 'bound'          => $bound,
                'name'           => $namelist,
                'userinfoprefix' => $userinfoprefix,
                'usertimeprefix' => $usertimeprefix,
              };
    return bless $obj, $class;
}

sub FETCH {
    my ($self, $index) = @_;
    ($index > $self->{'bound'}) && croak("Array out of bound: $index > $self->{bound}");
    # since script must run in a very short period of time, value will get from the cache
    # if it exist rather than reading from (up-to-date) file
    return($self->{name}->[$index]) if defined($self->{name}->[$index]);
    $filenames = join("", $self->{userinfoprefix}, '*.', $index);
    open FH, "<:utf8", (glob $filenames)[0] or return undef;
    $value = <FH>;
    close FH;
    chomp $value;
    return $self->{name}->[$index] = $value;
}

sub STORE {
    my ($self, $index, $value) = @_;
    ($index > $self->{'bound'}) && croak("Array out of bound: $index > $self->{bound}");
    $self->{name}->[$index] = $value;
    $filenames = join("", $self->{userinfoprefix}, '*.', $index);
    sysopen( FH, (glob $filenames)[0], O_TRUNC | O_WRONLY ) or croak("IO error while data store into array");
    binmode(FH, ":utf8");
    print FH $value;
    close FH;
    return $self->{name}->[$index] = $value;
}

sub EXISTS {
    my ($self, $index) = @_;
    ($index > $self->{'bound'}) && croak("Array out of bound: $index > $self->{bound}");
    return exists $self->{name}->[$index];
}

sub DELETE {
    my ($self, $index) = @_;
    ($index > $self->{'bound'}) && croak("Array out of bound: $index > $self->{bound}");
    delete $self->{name}->[$index];
    ( $result = unlink(glob("*.$index")) ) or croak("IO error while removing data");
    return 1;
}

sub FETCHSIZE {
    my $self = shift;
    return $self->{bound};
}

sub create {
    my ($self, $id, $value) = @_;
    for ($index = 0; $index < $self->{bound}; $index++) {
        exists($self->{name}->[$index]) && next;
        $file = join("", $self->{userinfoprefix}, $id, '.', $index);
        open(FH, ">:utf8", $file) or next;
        print FH $value;
        close FH;
        sleep(1);
        $filename1 = join("", $self->{userinfoprefix}, '*.', $index);
        @filelist = glob($filename1);

        ($#filelist > 0) and (unlink($file) or croak('cannont remove duplicated user file.'));
        return $index;
        last;
    }
    return undef;
}

sub whereami {
    my ($self, $id) = @_;

    my @filelist = glob(join("", $self->{userinfoprefix}, $id, ".*"));
    foreach (@filelist) { /.[0-9]+$/ and push @exactlist, $_; }
    return undef if ($#exactlist == -1);
    (undef, $value) = split /\./, $exactlist[0];

    return $value;
}

sub timelist {
    my $self = shift;
    my $userlist;
    $#{$userlist} = $self->{'bound'};

    $filename = join "", $self->{usertimeprefix}, "*.*";

    @filelist = glob($filename);
    foreach (@filelist) {
        tr/0-9.//cd;
        my ($value, $index) = split /\./;
        $index =~ /^[0-9]+$/ or next;
        $userlist[$index] = $value;
    }
    return \@userlist;
}

sub timecheck {
    my $self = shift;
    my $time = shift;
    $timelist = $self->timelist();
    for (my $i = 0; $i < $self->{'bound'}; $i++) {
        $expire[$i] = exists($$timelist[$i]) ? ($time > $$timelist[$i]) ? 1 : 0 : 0;
    }
    return wantarray ? @expire : \@expire;
}



#-------------------------------------------------------------------------------------------------
#
#       PACKAGE    Buffered_ContinuousFile
#
#

package Buffered_ContinuousFile;
use CGI::Carp;
use File::Copy;
use Fcntl;

sub TIEHANDLE {
    (scalar(@_) == 3) or croak "Usage: tie *typeglob, filename, max_line ";

    my $class       = shift;
    (my $filename   = shift) =~ s/\./_/g;
    my $maxline     = shift;

    my $datfile  = "${filename}.dat";
    my $bakfile  = "${filename}.bak";
    my $lockfile = "${filename}.lock";

    sysopen(my $self, $datfile, O_CREAT | O_RDONLY) or croak "Can't access or create $datfile: $!";
    close $self;

    $$self->{'data'}      = $datfile;
    $$self->{'backup'}    = $bakfile;
    $$self->{'lock'}      = $lockfile;
    $$self->{'maxline'}   = $maxline;

    return bless $self, $class;
}

#   subrountine OPEN
#          only support '>>', '>' and '<' mode
sub OPEN {
    my $self = shift;
    my $form = shift;
    $self->CLOSE;

    if ($form =~ /^>>$/) {
        sysopen($self, $$self->{'data'}, O_CREAT | O_WRONLY | O_APPEND) or croak("Can't open file" . $$self->{'data'} . ": $!");
        return 1;
    }
    elsif  ($form =~ /^>$/) {
        (-e $$self->{'backup'}) and
                (unlink($$self->{'backup'}) or croak "Can't delete file " . $$self->{'backup'} . ": $!");

        sysopen($self, $$self->{'data'}, O_CREAT | O_WRONLY | O_TRUNC) or croak("Can't open file" . $$self->{'data'} . ": $!");
        return 1;
    }
    else {
        sysopen($self, $$self->{'data'}, O_RDONLY) or croak("Can't open file" . $$self->{'data'} . ": $!");
        @$$self = <$self>;
        close $self;
        if (scalar(@$$self) < $$self->{'maxline'}) {
            (-e $$self->{'backup'}) or return 1;
            sysopen($self, $$self->{'backup'}, O_RDONLY);
            @temp = <$self>;
            close($self);
            unshift @$$self, @temp;
            (scalar(@$$self) > $$self->{'maxline'}) and
                    splice( @$$self, 0, (scalar(@$$self) - $$self->{'maxline'}) );
             return 1;
        }
        else {
            splice @$$self, 0, (scalar(@$$self) - $$self->{'maxline'});
            (-e $$self->{'lock'}) and ( (stat $$self->{'lock'})[9] - time > 2 ) and unlink($$self->{'lock'});
            sysopen(FH, $$self->{'lock'}, O_RDONLY | O_CREAT | O_EXCL) or return 1;
            close(FH);
            (-e $$self->{'backup'}) and
                (unlink($$self->{'backup'}) or croak "Can't delete file " . $$self->{'backup'} . ": $!");
            move($$self->{'data'}, $$self->{'backup'});
            unlink $$self->{'lock'};
            return 1;
        }
    }
}

sub CLOSE {
    my $self = shift;
    return close $self;
}

sub READLINE {
    my $self = shift;
    wantarray ? @$$self : shift @$$self;
}

sub PRINT {
    my $self = shift;
    print $self @_;
}

sub BINMODE {
    my $self = shift;
    my $disc = shift || ":raw";
    return binmode $self, $disc;
}
